/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;

public class VWConfigParameterTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 4;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_MODE = 2;
    public static final int COL_DESCRIPTION = 3;
    private static final String s_array = "[ ]";
    private VWOperationDefinition m_operationDefinition = null;
    private JDialog m_parentDialog = null;
    private JComboBox m_parameterTypeComboBox = null;
    private JComboBox m_parameterModeComboBox = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;
    private String m_type = null;
    private int m_nMode = -1;
    private String m_description = null;

    public VWConfigParameterTableModel(JDialog parentDialog) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_type = VWFieldType.getLocalizedString(4);
            this.m_nMode = 3;
            this.m_description = new String();
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getParameterTypeComboBox() {
        try {
            if (this.m_parameterTypeComboBox == null) {
                this.m_parameterTypeComboBox = new JComboBox();
                this.m_parameterTypeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(32));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(32) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + s_array);
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(16));
                this.m_parameterTypeComboBox.addItem(VWFieldType.getLocalizedString(16) + s_array);
                this.m_parameterTypeComboBox.addItem(VWResource.s_workflowGroup);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_parameterTypeComboBox;
    }

    public JComboBox getParameterModeComboBox() {
        try {
            if (this.m_parameterModeComboBox == null) {
                this.m_parameterModeComboBox = new JComboBox();
                this.m_parameterModeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_parameterModeComboBox.addItem(VWModeType.getLocalizedString(1));
                this.m_parameterModeComboBox.addItem(VWModeType.getLocalizedString(3));
                this.m_parameterModeComboBox.addItem(VWModeType.getLocalizedString(2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_parameterModeComboBox;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void refresh(VWOperationDefinition operationDef) {
        try {
            VWParameterDefinition[] parameterDefs;
            this.m_operationDefinition = operationDef;
            this.m_rowData.removeAllElements();
            if (this.m_operationDefinition != null && (parameterDefs = this.m_operationDefinition.getParameterDefinitions()) != null && parameterDefs.length > 0) {
                for (int i = 0; i < parameterDefs.length; ++i) {
                    this.m_rowData.addElement(parameterDefs[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef != null) {
                this.m_operationDefinition.deleteParameter(parameterDef.getName());
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_bIsModified = true;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
            case 1: {
                return VWResource.Type;
            }
            case 2: {
                return VWResource.Access;
            }
            case 3: {
                return VWResource.Description;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_operationDefinition != null && this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (parameterDef != null) {
                        return parameterDef.getName();
                    }
                    return new String();
                }
                case 1: {
                    return this.getParameterTypeString(parameterDef);
                }
                case 2: {
                    if (parameterDef != null) {
                        return VWModeType.getLocalizedString(parameterDef.getMode());
                    }
                    return VWModeType.getLocalizedString(this.m_nMode);
                }
                case 3: {
                    if (parameterDef != null) {
                        return parameterDef.getDescription();
                    }
                    return this.m_description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateType(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateMode(aValue, nRowIndex);
                break;
            }
            case 3: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    public VWParameterDefinition getRowItemAt(int nRowIndex) {
        VWParameterDefinition parameterDef = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            parameterDef = (VWParameterDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return parameterDef;
    }

    public void releaseResources() {
        this.m_operationDefinition = null;
        this.m_parentDialog = null;
        if (this.m_parameterTypeComboBox != null) {
            this.m_parameterTypeComboBox.removeAll();
            this.m_parameterTypeComboBox = null;
        }
        if (this.m_parameterModeComboBox != null) {
            this.m_parameterModeComboBox.removeAll();
            this.m_parameterModeComboBox = null;
        }
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_type = null;
        this.m_description = null;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String newName = (String)aValue;
            if (newName.length() == 0) {
                return;
            }
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef == null) {
                parameterDef = this.m_operationDefinition.createParameter(newName, this.m_nMode, this.getParameterType(this.m_type), this.isArrayType(this.m_type));
                if (parameterDef != null) {
                    parameterDef.setDescription(this.m_description);
                    this.m_description = new String();
                    this.m_rowData.addElement(parameterDef);
                    this.m_bIsModified = true;
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                }
            } else {
                if (VWStringUtils.compare(newName, parameterDef.getName()) == 0) {
                    return;
                }
                parameterDef.setName(newName);
                this.m_bIsModified = true;
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateType(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            String newType = aValue.toString();
            int nFieldType = this.getParameterType(newType);
            boolean isArray = this.isArrayType(newType);
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef != null) {
                parameterDef.setDataType(nFieldType);
                parameterDef.setIsArray(isArray);
                this.m_bIsModified = true;
            } else {
                this.m_type = newType;
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateMode(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef != null) {
                parameterDef.setMode(this.getMode(aValue.toString()));
                this.m_bIsModified = true;
            } else {
                this.m_nMode = this.getMode(aValue.toString());
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWParameterDefinition parameterDef = this.getRowItemAt(nRowIndex);
            if (parameterDef != null) {
                parameterDef.setDescription(aValue.toString());
                this.m_bIsModified = true;
            } else {
                this.m_description = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String getParameterTypeString(VWParameterDefinition parameterDef) {
        String type;
        block7: {
            type = null;
            try {
                if (parameterDef != null) {
                    switch (parameterDef.getDataType()) {
                        case 64: {
                            type = VWResource.s_workflowGroup;
                            break;
                        }
                        default: {
                            type = VWFieldType.getLocalizedString(parameterDef.getDataType());
                            if (parameterDef.getIsArray()) {
                                type = type + s_array;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block7;
                }
                type = this.m_type;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return type;
    }

    private int getParameterType(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + s_array) == 0) {
                return 32;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + s_array) == 0) {
                return 4;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(8)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + s_array) == 0) {
                return 8;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(1)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + s_array) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWResource.s_workflowGroup) == 0) {
                return 64;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(2)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + s_array) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(16)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + s_array) == 0) {
                return 16;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private boolean isArrayType(String type) {
        boolean bIsArray = false;
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + s_array) == 0 || VWStringUtils.compare(type, VWResource.s_workflowGroup) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + s_array) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + s_array) == 0) {
                bIsArray = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bIsArray;
    }

    private int getMode(String type) {
        try {
            if (VWStringUtils.compare(type, VWModeType.getLocalizedString(1)) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWModeType.getLocalizedString(3)) == 0) {
                return 3;
            }
            if (VWStringUtils.compare(type, VWModeType.getLocalizedString(2)) == 0) {
                return 2;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }
}

